function test_suite = testEq %#ok<STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
p = polysym.empty;
q = polysym.empty;
assertTrue(isempty(p==q))

function testDefault
p = polysym;
q = polysym;
assertTrue(p==q)

function testDefaultAndEmpty
p = polysym;
q = polysym.empty;
assertTrue(isempty(p==q))

function testDifferentScalars
polysyms('x','y')
assertTrue(~(x==y))

function testScalarVectorEqual
polysyms('x')
p = [x x x];
assertEqual(p==x,true(size(p)))

function testScalarVectorNotEqual
polysyms('x','y')
p = [x y x];
assertEqual(p==x,[true false true])

function testMatrices
polysyms('x','y')
p = [x y; y x];
q = [x x; y x];
assertEqual(p==q,[true false; true true])
